%analytical value of RNTK for Fig2 right
addpath('rntk/')
param = struct();
param.sigmaw = sqrt(2);
param.sigmau = 1;
param.sigmav = 1;
param.sigmab = 0.05;
param.L = 1;
param.sigmah = 0;
param.nonlinearity = 1;

T = 3;
N = [500,1000,2000,4000,8000,16000];

repeat = 100;
weightsharing = zeros(length(T),length(N),repeat);
nonweightsharing = zeros(length(T),length(N),repeat);
analytical = zeros(length(T),length(N),repeat);
tic
for i = 1:length(T)
    for j = 1:length(N)
        for r = 1:repeat
            n = N(j);
            x = randn(1,T(i));
            xp = randn(1,T(i));
            
            weights = struct();
            weights.w = randn(n,n);
            weights.u = randn(n,1);
            weights.b = randn(n,1);
            weights.v = randn(n,1);
            weightsharing(i,j,r)  = empericalrntk_weight_tied(x,xp,param,weights);
            
            weights = struct();
            weights.w = randn(n,n,T(i));
            weights.u = randn(n,1,T(i));
            weights.b = randn(n,1,T(i));
            weights.v = randn(n,1);
            nonweightsharing(i,j,r) = empericalrntk_weight_untied(x,xp,param,weights);
            
            analytical(i,j,r) = newRNTK(x,xp,param);
            
            percent = 100*((i-1)*length(N)*repeat + (j-1)*repeat + r)/(length(T)*length(N)*repeat);
            fprintf('%.2f percent complete \n',percent)
        end
    end
end
toc
%%
nonweightsharing = squeeze(nonweightsharing);
analytical = squeeze(analytical);
weightsharing = squeeze(weightsharing);
%%
a = log10(mean( ( (nonweightsharing' - analytical')./analytical' ).^2 ));
plot(a)
%%
b = log10(mean( ( (weightsharing' - analytical')./analytical' ).^2 ));
plot(b)


